/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa.peconnection;

import filenet.vw.apps.taskman.VWTaskClassLoader;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.pa.PANode;
import filenet.vw.apps.taskman.pa.peconnection.IPEConnection;
import filenet.vw.apps.taskman.pa.peconnection.PEConnectionImpl;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Locale;

public class PEConnectionFactory {
    public static IPEConnection getPEConnection(PANode node) throws Exception {
        File[] jarFiles;
        String installPath = VWTaskUtil.removeTrailingSlash(node.getProperty("TaskManager.CaseAnalyzer.Install"));
        StringBuffer classpath = new StringBuffer();
        File peConnDir = new File(installPath + File.separator + "peconnection");
        if (peConnDir.exists() && (jarFiles = peConnDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toUpperCase(Locale.ENGLISH).endsWith(".JAR");
            }
        })) != null) {
            for (int i = 0; i < jarFiles.length; ++i) {
                classpath.append(jarFiles[i].getAbsolutePath());
                classpath.append(File.pathSeparator);
            }
        }
        classpath.append(System.getProperty("java.class.path"));
        VWTaskClassLoader classLoader = VWTaskClassLoader.getInstance(classpath.toString(), "filenet");
        return new PEConnectionImpl(classLoader);
    }
}

